#include "CommunicationController.h"
#include <iostream>
#include "../XmlParser/xmlParser.h"

namespace Communication
{

CommunicationController::CommunicationController()
{
	sender = new CommunicationSender();
	ConfigurationServer *config = ConfigurationServer::GetInstance();
	sender->RegisterReceiver(config->GetSimulationEngineKey(),config->GetSimulationEnginePort(),config->GetSimulationEngineIP());
}

CommunicationController::~CommunicationController()
{
}

void CommunicationController::FreeResources()
{
	sender->FreeResources();
}

list <IAgent *> CommunicationController::GetAgents()
{
	return this->agents;
}
void CommunicationController::AddAgent(DataAgent *data)
{	
    AgentFactory *agentfact = AgentFactory::GetInstance();
    IAgent *agent = agentfact->GetAgent(data);

    timeb timeBuffer;
	ftime(&timeBuffer);
	double currentTime = timeBuffer.time;
    currentTime += timeBuffer.millitm * 0.001;
    agent->SetTimeStamp(currentTime);
    
    cout<<"Adding new Agent with ip:"<< data->GetIP()<<", key:"<< data->GetKey()<<" ,and port:"<<data->GetPort()<<endl;
	agents.push_back(agent);
	sender->RegisterReceiver(data->GetKey(),data->GetPort(),data->GetIP());
}

void CommunicationController::AgentInfoRequest(string keyrequester, string keyrequested)
{
	std::list<IAgent *>::iterator iter;
		
	bool found= false;
	iter = agents.begin();
	while (!found && iter!=agents.end())
	{
		if (keyrequested.compare((*iter)->GetKey())==0)
		{
			found = true;
		}
		else
			iter++;
	}
	
	if (found)
	{
		string tosend = "<Response>"+(*iter)->GetDataAgent()->ToString()+"</Response>";
		sender->SendMessage(keyrequester,tosend);
	}
		
}

void CommunicationController::ForwardMessage(string message)
{
	ConfigurationServer *config = ConfigurationServer::GetInstance();
	sender->SendMessage(config->GetSimulationEngineKey(),message);
}

void CommunicationController::BroadcastMessage(string message)
{
	std::list<IAgent *>::iterator iter;
	iter = agents.begin();
	while (iter!=agents.end())
	{		
		IAgent *currentagent =(*iter);
		double lasttime = currentagent->GetTimeStamp();
		timeb timeBuffer;
		ftime(&timeBuffer);
		double currentTime = timeBuffer.time;
        currentTime += timeBuffer.millitm * 0.001;
		double elapsedSeconds = currentTime - lasttime;
		//cout<<"el elapsedes" << elapsedSeconds<< ",lastt es  ;"<<lasttime<<" y  current es "<< currentTime<<" y el interval es "<<currentagent->GetBroadcastInterval()<<endl;
		if (currentagent->GetSyncMode()==true || elapsedSeconds>currentagent->GetBroadcastInterval())
		{
			currentagent->SetTimeStamp(currentTime);
			string tosend = currentagent->FilterData(message);
			sender->SendMessage(currentagent->GetKey(),tosend);
		}
		else
		{
			//cout<<"Not broadcast time"<<endl;
		}
			
		iter++;
	}
}

bool CommunicationController::ExistsAgent(string key)
{
	std::list<IAgent *>::iterator iter;		
	bool found= false;
	iter = agents.begin();
	while (!found && iter!=agents.end())
	{
		if (key.compare((*iter)->GetKey())==0)
		{			
			found = true;
		}
		else
			iter++;
	}	
	return found;
}

void CommunicationController::SynchronizeAgent(string key, int iteration)
{
	std::list<IAgent *>::iterator iter;
		
	bool found= false;
	iter = agents.begin();
	while (!found && iter!=agents.end())
	{
		if (key.compare((*iter)->GetKey())==0)
		{
			if ((*iter)->GetIterationSync()==iteration)
			{
				(*iter)->SetSyncFlag(true);
			}
			found = true;
		}
		else
			iter++;
	}
}

void CommunicationController::ResetSynchronization(int iteration)
{
	std::list<IAgent *>::iterator iter;

	iter = agents.begin();
	while (iter!=agents.end())
	{
		(*iter)->SetSyncFlag(false);
		(*iter)->SetIterationSync(iteration);
		iter++;
	}
}

bool CommunicationController::SyncRemaining()
{
	std::list<IAgent *>::iterator iter;
		
	bool found= false;
	iter = agents.begin();
	while (!found && iter!=agents.end())
	{
		if ((*iter)->GetSyncMode()&& (!(*iter)->GetSyncFlag()))
		{
			return true;
		}
		else
			iter++;
	}
	return false;
}

void CommunicationController::BroadcastResponse(string message)
{
	std::list<IAgent *>::iterator iter;
				
		iter = agents.begin();
		while (iter!=agents.end())
		{
			IAgent *currentagent =(*iter);			
			sender->SendMessage(currentagent->GetKey(),message);
			iter++;
		}
}

}
